<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Trial Balance</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
</head>

<body class="bg-gray-100 p-8">

    <div class="max-w-2xl mx-auto bg-white p-4 rounded shadow">
        <h2 class="text-2xl font-bold mb-4">Trial Balance</h2>

        <table class="min-w-full border border-black border-collapse mb-4">
            <thead>
                <tr class="bg-gray-200">
                    <th class="border border-black py-2 px-4">Account</th>
                    <th class="border border-black py-2 px-4">Debit</th>
                    <th class="border border-black py-2 px-4">Credit</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $accountingData = json_decode(file_get_contents('accounting_data.json'), true);

                foreach ($accountingData as $account => $balance) {
                    echo "<tr>";
                    echo "<td class='border border-black py-2 px-4'>$account</td>";
                    echo "<td class='border border-black py-2 px-4'>" . ($balance >= 0 ? $balance : "") . "</td>";
                    echo "<td class='border border-black py-2 px-4'>" . ($balance < 0 ? abs($balance) : "") . "</td>";
                    echo "</tr>";
                }

                $totalDebits = $totalCredits = 0;

                foreach ($accountingData as $balance) {
                    if ($balance >= 0) {
                        $totalDebits += $balance;
                    } else {
                        $totalCredits += abs($balance);
                    }
                }
                ?>
            </tbody>
            <tfoot>
                <tr class="bg-gray-200">
                    <td class="border border-black py-2 px-4">Total</td>
                    <td class="border border-black py-2 px-4"><?php echo $totalDebits; ?></td>
                    <td class="border border-black py-2 px-4"><?php echo $totalCredits; ?></td>
                </tr>
            </tfoot>
        </table>
    </div>

</body>

</html>
